import random
import argparse
import numpy as np

parser = argparse.ArgumentParser(description="config")
parser.add_argument("--input", type=str)
parser.add_argument("--output", type=str)
parser.add_argument("--max", type=float, default=1.0)
parser.add_argument("--min", type=float, default=0.0)
args = parser.parse_args()

filename = args.input
outfile = args.output

lst = []

with open(filename, "r") as f:
    lines = f.readlines()
    for line in lines:
        line = line.strip().split("\t")
        if int(line[3]) == 1:
            tmp = float(line[-1])
            if tmp > args.max:
                tmp = args.max
            if tmp < args.min:
                tmp = args.min
            lst.append(tmp)


with open(filename, "r") as f:
    lines = f.readlines()

    with open(outfile, "w") as g:

        for line in lines:
            line = line.strip().split("\t")

            if int(line[3]) == 1:
                tmp = float(line[-1])
                if tmp > args.max:
                    tmp = args.max
                if tmp < args.min:
                    tmp = args.min
                line[-1] = str(tmp)
                print("\t".join(line), file=g, flush=True)
            else:
                sample = random.choice(lst)
                line[-1] = str(sample)
                print("\t".join(line), file=g, flush=True)
                
            
